from django.shortcuts import redirect
from django.http import Http404
from django.contrib import messages
from smtplib import SMTPRecipientsRefused, SMTPAuthenticationError
from ipware import get_client_ip
import pytz
import requests
from django.utils import timezone


class Handle404RedirectMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):

        try:
            ip, is_routable = get_client_ip(
                request,
                proxy_order='left-most',
                proxy_count=1
            )

            tz_name = None

            if ip and is_routable:
                res = requests.get(
                    f"https://ipapi.co/{ip}/json/",
                    timeout=2
                ).json()
                tz_name = res.get("timezone")

            if tz_name:
                timezone.activate(pytz.timezone(tz_name))
            else:
                timezone.activate(pytz.timezone('Asia/Kolkata'))  # fallback

        except Exception:
            timezone.activate(pytz.timezone('Asia/Kolkata'))

        try:
            response = self.get_response(request)

            if hasattr(response, "status_code") and response.status_code == 404:
                return redirect('/')

            return response

        except Http404:
            return redirect('/')

        except SMTPRecipientsRefused:
            messages.error(request, "Invalid email address. Please try again.")
            return redirect(request.path)

        except SMTPAuthenticationError:
            messages.error(request, "Email authentication failed. Please check SMTP username/password.")
            return redirect(request.path)

        except Exception as e:
            print("GLOBAL ERROR:", str(e))
            messages.error(request, "Something went wrong. Please try again.")
            return redirect(request.path)
